
#include <stdio.h>
#include <locale.h>    /* include the declaraiton of setlocale(),
                          localeconv() etc. */
#include <stdlib.h>    /* include the declaration of mblen(), wctomb(),
                          mbtowc(), wcstombs(), mbstowcs() */

/* NOTE: mbstowcs() returns -1 if invalid character is encountered. */ 
/*       There will be no indication of where the error occurs.     */ 
/*       This will be a problem if you use mbstowcs to convert      */ 
/*       a large block of data for conversion to wide character     */ 
/*       form. You might want to use mbtowc repeatedly to convert   */ 
/*       one character at a time to wide character form.            */ 

main() {
			/* a multibyte character string for you to process. */
    char mbstring[100] = "ʸϤƲ: SCSI󷶥";
    wchar_t *pwcs;	/* the wide character array to keep the wide char.
			   form of "mbstring". */
    int  n;             /* the character position specified by the user
                           from stdin. */
    int  bytect, retval; /* working variables. */
    char *mbchar;        /* pointing to a string that can hold a multibyte
	                    character. */

    (void) setlocale(LC_ALL, ""); /* always do setlocale() */

    /**********************************************************************/
    /* Task 1. Convert "mbstring" to wide character string pointed to     */
    /*         to by pwcs. The steps to be taken would be:                */
    /*         1. Find out the byte count of "mbsting" using "strlen()"   */
    /*         2. The worst case would be every character in "mbstring"   */
    /*            is a single-byte character, therefore you want to       */
    /*            allocate the storage big enough to hold "byte-count+1"  */
    /*            wide characters. Use pwcs to point to the allocated     */
    /*            storage.                                                */
    /*         3. Call "mbstowcs()" to convert "mbstring" to the          */
    /*            storage allocated in pwcs.                              */
    /**********************************************************************/

    bytect = strlen(mbstring); /* How many byte ? */
                               /* string length + terminating null */
    pwcs = (wchar_t *) malloc( (bytect+1) *sizeof(wchar_t) );
				/* convert mbstring to wide character
				   string pointed to by pwcs. */
    retval = mbstowcs(pwcs, mbstring, bytect);

    if ( retval <= 0 ) {
         printf("There is an invalid multibyte char in the string.\n");
         printf("But we don't know the positions of the invalid char.\n");
         exit(-1);
    	}

    /**********************************************************************/
    /* The following loop prompts for users to enter a character position */
    /* until "q" is entered.                                              */
    /**********************************************************************/
			/* "mbchar" can hold a multibyte character. it is
                           big enough for a character with the maximum
			   number of bytes possible in the current locale.*/
    mbchar = (char *) malloc( MB_CUR_MAX +1 ); 

    printf("Enter the character position desired(enter q to stop):\n");
    while ( scanf("%d", &n) ) {
        /******************************************************************/
        /* TASK 2: Find the n'th character, and print out the number of   */
        /*         in its original multibyte form. You can directly index */
        /*         into the wide character array to get the n'th          */
        /*         character, but you need to convert it back to multibyte*/
        /*         form in order to know the number of bytes in its       */
        /*         original multibyte form. Use wctomb() to do the        */
        /*         conversion and use "mbchar" to hold your multibyte     */
        /*         character.                                             */
        /******************************************************************/
        retval = wctomb(mbchar, pwcs[n-1]);

	printf("The %dth char has %d bytes.\n\n", n, retval); 
    	printf("Please enter the character position desired:\n");
    } /* while ( scanf("%d", &n) */
}
